# Deszyfrowanie wiadomości chronionej szyfrem przestawieniowym:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

import math, pyperclip

def main():
    myMessage = 'Cenoonommstmme oo snnio. s s c'
    myKey = 8

    plaintext = decryptMessage(myKey, myMessage)

    # Wyświetlenie znaku potoku (|) na końcu, na wypadek
    # gdyby szyfrowana wiadomość kończyła się spacją.
    print(plaintext + '|')

    pyperclip.copy(plaintext)


def decryptMessage(key, message):
    # Ta funkcja deszyfrowania będzie symulowała "kolumny" i "wiersze"
    # siatki, na której zostanie umieszczony zwykły tekst na podstawie
    # listy ciągów tekstowych; najpierw trzeba obliczyć kilka wartości.

    # Liczba kolumn siatki.
    numOfColumns = int(math.ceil(len(message) / float(key)))
    # Liczba wierszy siatki.
    numOfRows = key
    # Liczba "zamazanych kratek" w ostatniej "kolumnie" naszej siatki.
    numOfShadedBoxes = (numOfColumns * numOfRows) - len(message)

    # Każdy ciąg tekstowy w zwykłym tekście reprezentuje kolumnę w siatce.
    plaintext = [''] * numOfColumns

    # Zmienne column i row wskazują kratkę siatki w której,
    # ma zostać umieszczony następny znak szyfrogramu.
    column = 0
    row = 0

    for symbol in message:
        plaintext[column] += symbol
        column += 1  # Wskazuje następną kolumnę.

        # Jeżeli nie ma więcej kolumn LUB bieżąca kratka jest zamazana, wówczas
        # należy powrócić do pierwszej kolumny i przejść do następnego wiersza.

        if (column == numOfColumns) or (column == numOfColumns - 1 and row >= numOfRows - numOfShadedBoxes):
            column = 0
            row += 1

    return ''.join(plaintext)


# Jeżeli program transpositionDecrypt.py został uruchomiony (a nie
# zaimportowany jako moduł), wówczas należy wywołać funkcję main().
if __name__ == '__main__':
    main()
